package gov.va.vamf.scheduling.direct.domain;

import com.agilex.healthcare.veteranappointment.domain.Namespace;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Optional;
import java.util.function.Predicate;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.DirectScheduling)
public class CoreSettings extends DomainBaseObjects<CoreSetting> {

    public static final String PRIMARY_CARE_ID = "323";
    public static final String OUTPATIENT_MENTAL_HEALTH_ID = "502";
    public static final String EXPRESS_CARE_ID = "CR1";
    public static final String DEFAULT_TIMEZONE = "America/New_York";
    public static final String DEFAULT_CURRENT_TZ = "EST";
    public static final String DEFAULT_TZ_OFFSET = "-05:00";

    public Optional<CoreSetting> findCoreSettingById(final String id) {
        return this
                .stream()
                .filter(new Predicate<CoreSetting>() { // TODO: switch to lambda
                    @Override
                    public boolean test(final CoreSetting coreSetting) {
                        return coreSetting.getId().equals(id);
                    }
                })
                .findFirst();
    }
}
